#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_InvoiceException : BaseTest 
	{
		private string exceptionText = "InvoiceException";
		private string innerText = "InnerException";
		private string genericErrorText = "Exception of type 'gov.va.med.vbecs.BOL.InvoiceException' was thrown.";

		
		[Test]
		[ExpectedExceptionAttribute(typeof(InvoiceException))]
		public void Ctor_Pass()
		{
			throw new BOL.InvoiceException();
		}

				
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}


		[Test]
		public void Ctor_String_Pass()
		{
			try
			{
				throw new BOL.InvoiceException(exceptionText);
			}
			catch (BOL.InvoiceException ex)
			{
				Assert.AreEqual(exceptionText, ex.Message);
			}
		}

		[Test]
		public void Ctor_String_Fail()
		{
			try
			{
				throw new BOL.InvoiceException(null);
			}
			catch (BOL.InvoiceException ex)
			{
				Assert.AreEqual(ex.Message, genericErrorText);
			}
		}

		[Test]
		public void Ctor_String_Exc_Pass()
		{
			try
			{
				throw new BOL.InvoiceException(exceptionText, new Exception(innerText));
			}
			catch (BOL.InvoiceException ex)
			{
				Assert.AreEqual(exceptionText, ex.Message);
				Assert.AreEqual(innerText, ex.InnerException.Message);
			}
		}

		[Test]
		public void Ctor_String_Exc_Fail()
		{
			try
			{
				throw new BOL.InvoiceException(null, null);
			}
			catch (BOL.InvoiceException ex)
			{
				Assert.AreEqual(genericErrorText, ex.Message);
				Assert.IsNull(ex.InnerException);
			}
		}

	}

}
#endif


